/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.block;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.data.DRGeneratorNetwork;
import mcjty.deepresonance.modules.generator.data.GeneratorBlob;
import mcjty.deepresonance.modules.generator.data.NetworkEnergyStorage;
import mcjty.deepresonance.modules.generator.util.GeneratorConfig;
import mcjty.lib.multiblock.IMultiblock;
import mcjty.lib.multiblock.IMultiblockConnector;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.multiblock.MultiblockSupport;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class GeneratorPartTileEntity
extends TickingTileEntity
implements IMultiblockConnector {
    private int blobId = -1;
    @Cap(type=CapType.ENERGY)
    private final NetworkEnergyStorage energyStorage = new NetworkEnergyStorage(this);
    private int preservedEnergy;

    public GeneratorPartTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GeneratorModule.TYPE_GENERATOR_PART.get(), pos, state);
    }

    public void tickServer() {
        int energyStored = this.energyStorage.getEnergyStored();
        if (energyStored <= 0) {
            return;
        }
        boolean dirty = false;
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            Direction opposite;
            BlockPos pos = this.m_58899_().m_142300_(facing);
            BlockEntity te = this.f_58857_.m_7702_(pos);
            if (!EnergyTools.isEnergyTE((BlockEntity)te, (Direction)(opposite = facing.m_122424_()))) continue;
            int rfToGive = Math.min((Integer)GeneratorConfig.POWER_PER_TICKOUT.get(), energyStored);
            int received = (int)EnergyTools.receiveEnergy((BlockEntity)te, (Direction)opposite, (long)rfToGive);
            if (received > 0) {
                dirty = true;
                energyStored -= this.energyStorage.consumeEnergy(received);
            }
            if (energyStored <= 0) break;
        }
        if (dirty) {
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.f_58857_);
            generatorNetwork.m_77762_();
        }
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!world.m_5776_()) {
            CompoundTag tag;
            this.addBlockToNetwork();
            GeneratorBlob network = this.getBlob();
            if (network != null && (tag = stack.m_41783_()) != null) {
                int energy = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"preserved", (Object)0);
                this.getDriver().modify(this.getMultiblockId(), holder -> ((GeneratorBlob)holder.getMb()).setEnergy(((GeneratorBlob)holder.getMb()).getEnergy() + energy));
            }
        }
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.m_128441_("Info")) {
            this.preservedEnergy = tagCompound.m_128469_("Info").m_128451_("preserved");
        }
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        this.getOrCreateInfo(tagCompound).m_128405_("preserved", this.preservedEnergy);
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (!world.m_5776_()) {
            BlockState stateDown;
            BlockState stateUp;
            if (newstate.m_60734_() != GeneratorModule.GENERATOR_PART_BLOCK.get()) {
                GeneratorBlob network = this.getBlob();
                if (network != null) {
                    int energy = network.getEnergy() / network.getGeneratorBlocks();
                    network.setEnergy(network.getEnergy() - energy);
                    this.preservedEnergy = energy;
                } else {
                    this.preservedEnergy = 0;
                }
                this.m_6596_();
                this.removeBlockFromNetwork();
            }
            if ((stateUp = world.m_8055_(pos.m_7494_())).m_60734_() == GeneratorModule.GENERATOR_PART_BLOCK.get()) {
                world.m_7260_(pos.m_7494_(), stateUp, stateUp, 3);
            }
            if ((stateDown = world.m_8055_(pos.m_7495_())).m_60734_() == GeneratorModule.GENERATOR_PART_BLOCK.get()) {
                world.m_7260_(pos.m_7495_(), stateDown, stateDown, 3);
            }
        }
    }

    public void addBlockToNetwork() {
        GeneratorBlob newMb = new GeneratorBlob().setGeneratorBlocks(1).setActive(false);
        MultiblockSupport.addBlock((Level)this.f_58857_, (BlockPos)this.m_58899_(), DRGeneratorNetwork.getNetwork(this.f_58857_).getDriver(), (IMultiblock)newMb);
    }

    public void removeBlockFromNetwork() {
        MultiblockSupport.removeBlock((Level)this.f_58857_, (BlockPos)this.m_58899_(), DRGeneratorNetwork.getNetwork(this.f_58857_).getDriver());
    }

    public void setMultiblockId(int newId) {
        if (this.blobId != newId) {
            this.blobId = newId;
            this.m_6596_();
        }
    }

    public ResourceLocation getId() {
        return DRGeneratorNetwork.GENERATOR_NETWORK_ID;
    }

    public int getMultiblockId() {
        return this.blobId;
    }

    private MultiblockDriver<GeneratorBlob> getDriver() {
        return DRGeneratorNetwork.getNetwork(this.f_58857_).getDriver();
    }

    public GeneratorBlob getBlob() {
        if (this.blobId == -1) {
            return null;
        }
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.f_58857_);
        return generatorNetwork.getOrCreateBlob(this.blobId);
    }

    public void activate(boolean active) {
        GeneratorBlob network = this.getBlob();
        if (network != null && network.isActive() != active) {
            this.getDriver().modify(this.getMultiblockId(), holder -> ((GeneratorBlob)holder.getMb()).setActive(active));
            HashSet done = Sets.newHashSet();
            this.activateBlocks(this.m_58899_(), done, active);
        }
    }

    private void activateBlocks(BlockPos c, Set<BlockPos> done, boolean active) {
        done.add(c);
        BlockState state = this.f_58857_.m_8055_(c);
        if ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != active) {
            this.f_58857_.m_7731_(c, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(active)), 3);
        }
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            Block block;
            BlockPos newC = c.m_142300_(direction);
            if (done.contains(newC) || (block = this.f_58857_.m_8055_(newC).m_60734_()) != GeneratorModule.GENERATOR_PART_BLOCK.get()) continue;
            this.activateBlocks(newC, done, active);
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128405_("networkId", this.blobId);
        super.m_183515_(tagCompound);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.blobId = tagCompound.m_128451_("networkId");
    }
}

